<!-- Modal Ubah User -->
<div class="modal fade" id="ubahKaryawan{{ $item->id }}" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content shadow-lg border-0">

            <div class="modal-header bg-warning text-dark">
                <h5 class="modal-title">
                    <i class="fas fa-user-edit me-2"></i> Ubah Data
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <form action="{{ route('admin.karyawan.update', $item->id) }}" method="POST">
                @csrf
                @method('PUT')

                <div class="modal-body">


                    <div class="mb-3">
                        <label class="form-label fw-semibold">NIP</label>
                        <input type="text" name="nip" class="form-control" value="{{ $item->nip }}" required>
                    </div>

                    <div class="mb-3">
                        <label for="departemen_id{{ $item->id }}" class="form-label">Nama Departemen</label>
                        <select name="departemen_id" id="departemen_id{{ $item->id }}" class="form-select" required>
                            <option value="" disabled>Pilih departemen....</option>
                            @foreach ($departemen as $list)
                                <option value="{{ $list->id }}"
                                    {{ $item->departemen_id == $list->id ? 'selected' : '' }}>
                                    {{ $list->nama }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="jabatan_id{{ $item->id }}" class="form-label">Jabatan</label>
                        <select name="jabatan_id" id="jabatan_id{{ $item->id }}" class="form-select" required>
                            <option value="" disabled>Pilih Jabatan....</option>
                            @foreach ($jabatan as $list)
                                <option value="{{ $list->id }}"
                                    {{ $item->jabatan_id == $list->id ? 'selected' : '' }}>
                                    {{ $list->nama_jabatan }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-semibold">Status</label>
                        <select name="status" class="form-select" required>
                            <option value="aktif" {{ $item->status == 'aktif' ? 'selected' : '' }}>Aktif</option>
                            <option value="nonaktif" {{ $item->status == 'nonaktif' ? 'selected' : '' }}>Nonaktif
                            </option>
                        </select>
                    </div>

                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        Batal
                    </button>
                    <button type="submit" class="btn btn-warning">
                        Simpan Perubahan
                    </button>
                </div>

            </form>

        </div>
    </div>
</div>
